<?php
require __DIR__ . '/vendor/autoload.php'; // Composer dependencies
use Minishlink\WebPush\VAPID;

// Server address (replace with your actual domain)
$serverAddress = 'https://your-server.com';

// Database connection
$pdo = new PDO("mysql:host=localhost;dbname=sankrit_binance", "sankrit_binance", ")7=%&axL!?^u");

// Get the subdomain from the form
$subdomain = trim($_POST['subdomain']);
if (!$subdomain) {
    die("Subdomain is required.");
}

// Generate VAPID keys
$vapidKeys = VAPID::createVapidKeys();
$publicKey = $vapidKeys['publicKey'];
$privateKey = $vapidKeys['privateKey'];

// Save VAPID keys to the database
$stmt = $pdo->prepare("INSERT INTO vapid_keys (subdomain, public_key, private_key) VALUES (?, ?, ?) 
                        ON DUPLICATE KEY UPDATE public_key = VALUES(public_key), private_key = VALUES(private_key)");
$stmt->execute([$subdomain, $publicKey, $privateKey]);

// Create subdomain folder structure
$templatePath = __DIR__ . '/subdomain-template/';
$subdomainPath = __DIR__ . "/zips/{$subdomain}/";
if (!is_dir($subdomainPath)) {
    mkdir($subdomainPath, 0777, true);
}

// Copy and customize template files
foreach (scandir($templatePath) as $file) {
    if ($file !== '.' && $file !== '..') {
        $fileContent = file_get_contents($templatePath . $file);

        // Replace placeholders
        $fileContent = str_replace('{{PUBLIC_KEY}}', $publicKey, $fileContent);
        $fileContent = str_replace('{{PRIVATE_KEY}}', $privateKey, $fileContent);
        $fileContent = str_replace('{{SERVER_ADDRESS}}', $serverAddress, $fileContent);

        // Save customized file
        file_put_contents($subdomainPath . $file, $fileContent);
    }
}

// Create a ZIP file
$zip = new ZipArchive();
$zipFileName = __DIR__ . "/zips/{$subdomain}.zip";
if ($zip->open($zipFileName, ZipArchive::CREATE) === TRUE) {
    $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($subdomainPath));
    foreach ($files as $file) {
        if (!$file->isDir()) {
            $filePath = $file->getRealPath();
            $relativePath = substr($filePath, strlen($subdomainPath));
            $zip->addFile($filePath, $relativePath);
        }
    }
    $zip->close();
    echo "ZIP file created: <a href='zips/{$subdomain}.zip'>Download {$subdomain}.zip</a>";
} else {
    echo "Failed to create ZIP file.";
}
?>
